# PL-300 Case Study Data Files

## Overview
This data package contains real gym workout data split across three files for use in the Power BI Data Analyst (PL-300) certification case study.

## Files Included

### 1. workout_sets.csv (Fact Table)
Individual workout sets with details about each lift performed.

**Columns:**
- id: Unique identifier for each set
- date: Date of the workout (YYYY-MM-DD)
- exercise: Name of the exercise
- weight: Weight lifted (in pounds or kg)
- reps: Number of repetitions
- setNumber: Set number within the workout
- timestamp: Full timestamp of when the set was logged
- dayTag: Workout split tag (e.g., "push day", "leg day")
- isUnilateral: Whether the exercise is unilateral (true/false)
- equipment: Equipment used (e.g., "barbell", "dumbbell")

**Use in Power BI:** This is your fact table containing the transactional data.

### 2. dim_exercises.csv (Dimension Table)
Exercise catalog with body part mappings.

**Columns:**
- id: Unique identifier for the exercise
- exercise_name: Name of the exercise
- body_part_key: Key linking to body parts table
- is_active: Whether the exercise is currently active

**Use in Power BI:** This is a dimension table for exercise lookups and categorization.

### 3. dim_body_parts.csv (Dimension Table)
Body part/muscle group reference.

**Columns:**
- body_part_key: Unique key for the body part
- body_part_label: Human-readable label

**Use in Power BI:** This is a dimension table for muscle group categorization.

## Suggested Data Model (Star Schema)

```
workout_sets (Fact)
├── [exercise] → dim_exercises[exercise_name] (many-to-one)
├── [date] → Date[Date] (many-to-one, create Date table in Power BI)
└── dim_exercises
    └── [body_part_key] → dim_body_parts[body_part_key] (many-to-one)
```

## Getting Started

1. Extract all files from this ZIP
2. Open Power BI Desktop
3. Import workout_sets.csv using "Text/CSV" connector
4. Import dim_exercises.csv
5. Import dim_body_parts.csv
6. Create a Date table using DAX
7. Build relationships as shown above
8. Follow the case study steps!

## Questions?
Refer to the case study guide for detailed step-by-step instructions.

Good luck with your PL-300 prep! 🚀
